/* Adobe.Transform.js */

define([    "lib/Zoot",
		"lib/dev", "lib/tasks"
	], 
function(   Z,
		dev, tasks
	) {
	"use strict";

	var kAbout = "$$$/private/animal/Behavior/Transform/About=Transform, (c) 2014.",
		radians = Z.mathUtils.rad,
		mat3 = Z.Mat3;

	return {
		about: kAbout,
		description:	"$$$/animal/Behavior/Transform/Desc=Moves puppet handles",
		uiName:			"$$$/animal/Behavior/Transform/UIName=Transform",
		defaultArmedForRecordOn: true,

		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				// TODO: change these to point controls when available
				{id:"anchorPtX", type:"slider", uiName:"$$$/animal/Behavior/Transform/Param/AnchorPointX=Anchor Point X",	precision:1, dephault:0},
				{id:"anchorPtY", type:"slider", uiName:"$$$/animal/Behavior/Transform/Param/AnchorPointY=Anchor Point Y",	precision:1, dephault:0},
				{id:"positionX", type:"slider", uiName:"$$$/animal/Behavior/Transform/Param/PositionX=Position X",	precision:1, dephault:0},
				{id:"positionY", type:"slider", uiName:"$$$/animal/Behavior/Transform/Param/PositionY=Position Y",	precision:1, dephault:0},
				{id:"uniformScale", type:"slider",	uiName:"$$$/animal/Behavior/Transform/Param/Scale=Scale",		precision:1, uiUnits:"%", dephault:100},
				{id:"scaleX", type:"slider",		uiName:"$$$/animal/Behavior/Transform/Param/ScaleX=Scale X",	precision:1, uiUnits:"%", dephault:100},
				{id:"scaleY", type:"slider",		uiName:"$$$/animal/Behavior/Transform/Param/ScaleY=Scale Y",	precision:1, uiUnits:"%", dephault:100},
				{id:"skew", type:"slider",			uiName:"$$$/animal/Behavior/Transform/Param/Skew=Skew",			min:-85, max:85, precision:1, dephault:0, hidden : true},
				{id:"skewAxis", type:"angle", 		uiName:"$$$/animal/Behavior/Transform/Param/SkewAxis=Skew Axis",	precision:0, dephault:0, hidden : true},
				{id:"rotation", type:"angle",		uiName:"$$$/animal/Behavior/Transform/Param/Rotation=Rotation", precision:0, dephault:0},

				{id:"opacity", type:"slider",		uiName:"$$$/animal/Behavior/Transform/Param/Opacity=Opacity", min:0, max:100, precision:0, dephault:100, uiUnits:"%"},
				{id: "groupOpacity", type: "checkbox", uiName: "$$$/animal/Behavior/Transform/Param/GroupOpacity=Group Opacity",
					uiToolTip: "$$$/animal/Behavior/Transform/Parameter/GroupOpacity/tooltip=Set opacity of all layers as a group; uncheck to set each layer individually", dephault: false }
			];
		},
		
		onCreateBackStageBehavior: function (/*self*/) {
			return {
				order : 0.0,
				importance : 1.0
			};
		},
		
		onCreateStageBehavior: function (self, args) {
		},
		
		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage
			var anchorPt = Z.Vec2([-args.getParam("anchorPtX"), -args.getParam("anchorPtY")]),
				position = Z.Vec2([args.getParam("positionX"), args.getParam("positionY")]),
				uniformScale = args.getParam("uniformScale") * 0.01 * 0.01,
				scale = Z.Vec2([args.getParam("scaleX"), args.getParam("scaleY")]),
				skewAmount = args.getParam("skew"),
				skewAxis = args.getParam("skewAxis"),
				angle = args.getParam("rotation"),
				groupOpacityB = args.getParam("groupOpacity") ? true : false,
				transform = mat3(),
				privateLayer = args.stageLayer.privateLayer,
				handle = privateLayer.getHandleTreeRoot();

			args.stageLayer.setOpacity(args.getParam("opacity")/100);
			
			// Need to compare against the layer binding to determine whether to set to "In Front" or undefined.
			var blendMode = args.stageLayer.getBlendMode();
			if (groupOpacityB) {
				if (!blendMode) {
					args.stageLayer.setBlendMode("In Front");
				}
			}

			transform = transform.setIdentity()
				.translate(position)
				.rotate(radians(angle))
				.scale(scale.scale(uniformScale))
				.skew(radians(skewAmount), radians(skewAxis))
				.translate(anchorPt);

			// tasks.handle.setFrame(handle, transform, tasks.dofs.type.kAffine);
			tasks.handle.moveFrameBy(handle, transform);
		}
			
	}; // end of object being returned
});
